TILE_FIRE=3
TILE_PIKE=9

TILE_RED=25

TILE_START=32

TILE_ENEMY=33
TILE_ENEMY2=34
TILE_ENEMY3=35

TILE_LADDER=2
TILE_PICKAXE=4
TILE_SOLID=15

TILE_GOLD=1
TILE_TELEPORT=11

TILE_MINE=21
TILE_ACTIVEMINE=28

TILE_LEFT=22
TILE_RIGHT=23

TILE_ANTILEFT=26
TILE_ANTIRIGHT=27

TILE_MEGASOLID=24

TILE_BRIDGE1=17
TILE_BRIDGE=18
TILE_BRIDGE2=19

levels:	dw level00
		dw level01,level02,level03,level04,level05
		dw level06,level07,level08,level09,level10
		dw level11,level12,level13,level14,level15
		dw level16,level17,level18,level19,level20
		dw level21       

delay:
;delay
	ld b,48
1:
	dup 10 : ld (0),bc : edup
	djnz 1b
	ret

haltDelay:
	halt
	djnz haltDelay
	ret
initLevel:		


	call clearSprites
	ld a,75 : ld (deadCount),a
    call resetHero
	call resetEnemies
	call resetMines
	xor a: ld (totalGold),a

	halt
	call delay : ld   A,(borderColor) : ld   (BDRCLR),A  : call CHGCLR
    call DISSCR ;disable screen
	halt : halt 
;========= UGLY PART ======================
	call fillTiles01
	ld a,(currentLevel)
	cp 11
	jr c,1f
	cp 16
	jr c,2f
	call fillTiles03
	jr 1f
2:
	call fillTiles02
1:

;==========================================
	halt
	call delay : ld   A,1 : ld   (BDRCLR),A  : call CHGCLR
	
	

    ld a,(currentLevel)
   	ld hl,levels :  add a,a : ld c,a : ld b,0 : add hl,bc
	ld a,(hl): inc hl : ld h,(hl) : ld l,a

    ;unpack level
    ld de,map : call DEC40
    call showLevel
	
	ld b,10 : call haltDelay
	halt : 	call delay : ld   A,4 : ld   (BDRCLR),A : call CHGCLR
	halt : halt : halt
	
	halt : 	call delay : ld   A,1 : ld   (BDRCLR),A : call CHGCLR    
	call doHero : call doEnemies : call doSprites

	call updateStatusBar: call drawGold : call drawPickaxe

	halt	
    call ENASCR ;enable screen	
	ld a,4 : ld (borderColor),a

	di
    call initMusic
    ei
    halt
    halt

    ret

showLevel:
	ld iy,enemiesList;pointer to start of enemies list
    ;skip top row
    ld ix,map+32
    ld de, 00000+256

    ld b,23
2:
    push bc

    ld b,32
1:
    ld a,(ix)
	cp TILE_START
	call z,setStartPoint

	cp TILE_ENEMY
	call z,addEnemy

	cp TILE_GOLD
	jr nz,6f
	push af : ld a,(totalGold) : inc a : ld (totalGold),a : pop af
6:

    push de : call fillTile : pop de
	

    inc e
    inc ix
    djnz 1b
    inc d : ld e,0
    pop bc
    djnz 2b  
	ret

addEnemy:
	push de : push bc
	ld (ix),0 ;tile
	;get real coords and put it to enemy coords
	ld a,e : add a,a : add a,a : add a,a : ld (iy+1),a : ld (iy+12),a
	ld a,d : add a,a : add a,a : add a,a  : sub 2 : ld (iy+13),a : ld (iy+2),a	

	;move to next enemy
	ld bc, 16 : add iy,bc
	pop bc : pop de
	xor a;reset tile
	ret

setStartPoint:
    ld a,e : add a,a : add a,a : add a,a : ld (heroPosition),a
    ld a,d: add a,a : add a,a : add a,a : sub 4 : ld (heroPosition+1),a
    ld (ix),0

    xor a; reset tile
    ret

;de - real coords
;out: de-tile coords
;     hl - map coords
getTileCoords:
;fix x
	ld a,e : add 4
	rra : rra : rra ;/8
	and 31
	ld e,a	

	;get y
	ld a,d : add 6
	rra : rra : rra ;/8
	and 31
	ld d,a

	push de

	ld h, high mapLines
	add a,a;x2 2bytes per addr
	ld l,a
	ld a,(hl): inc l : ld h,(hl) : ld l,a
	
	ld d,0 : add hl,de

	pop de

	ret


;de - coords
getTile:	
	;fix x
	ld a,e : add 4
	rra : rra : rra ;/8
	and 31
	ld e,a	

	;get y
	ld a,d : add 6
	rra : rra : rra ;/8
	and 31

	ld h, high mapLines
	add a,a;x2 2bytes per addr
	ld l,a
	ld a,(hl): inc l : ld h,(hl) : ld l,a
	
	ld d,0 : add hl,de

	ld a,(hl)

	ret

	align 256
mapLines:
N=0
	dup 24
	dw map+N*32
N=N+1
	edup
